package h23.numberplace;

import h23.sudoku.R;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.Color;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.Spinner;
import android.widget.TextView;

public class NumberPlaceGenerator extends Activity {
    /** Called when the activity is first created. */
	public ModeManager mm;
	private Board b;
	private TextView boardCells[][];
	private TextView insertNumbers[];
	private int selectedCellx = -1;
	private int selectedCelly = -1;
	private BoardSaver bs;

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        mm = new ModeManager();
        b = new Board();
        boardCells = new TextView[9][9];
        insertNumbers = new TextView[9];
        bs = new BoardSaver(this);
        readData();
        Init();
        draw();
    }

    public void onDestroy(){
    	bs.setData(b.getBoard(), b.getAnswer(), b.getEnable());
    	bs.save();
    	super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event){
    	if(keyCode == KeyEvent.KEYCODE_BACK){
    		if(mm.getMode() == 0){
    			return super.onKeyDown(keyCode, event);
    		}else if(mm.getMode() == 1){
    			mm.setMode(0);
    			Init();
    			draw();
    			return true;
    		}
    	}

    	return super.onKeyDown(keyCode, event);
    }

    private void readData(){
    	GameData data = bs.getGameData();
    	if(data == null){
    		return;
    	}

    	b.setBoard(data.board);
    	b.setAnswer(data.answer);
    	b.setEnableChange(data.enable);
    }

    private void Init(){
    	mm.setMode(0);
    	selectedCellx = -1;
    	selectedCelly = -1;
    }

    public boolean onCreateOptionsMenu(Menu menu){
    	super.onCreateOptionsMenu(menu);
    	MenuInflater inflater = getMenuInflater();
    	inflater.inflate(R.menu.menu, menu);
		return true;
    }

    public boolean onOptionsItemSelected(MenuItem item){
    	switch(item.getItemId()){
    	case R.id.done:
    		AlertDialog.Builder builder = new AlertDialog.Builder(this);
    		if(b.isCorrect()){
    			builder.setMessage("GOOD");
    			builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
    				public void onClick(DialogInterface di, int button) {
    					setResult(RESULT_OK);
    					Init();
    					draw();
    				}
    			});
    		}else{
    			builder.setMessage("WRONG");
    			builder.setPositiveButton("OK", new DialogInterface.OnClickListener() {
    				public void onClick(DialogInterface di, int button) {
    					setResult(RESULT_OK);
    				}
    			});
    		}
    		builder.create();
    		builder.show();
    		return true;
    	case R.id.home:
    		Init();
    		draw();
    		return true;
    	case R.id.exit:
    		finish();
    		return true;
    	case R.id.clear:
    		for(int i=0;i<9;i++){
    			for(int j=0;j<9;j++){
    				if(b.getEnableChange(i, j)){
    					b.changeBoard(i, j, 0);
    					cellReload(i, j);
    				}
    			}
    		}
    		return true;
    	}

    	return false;
    }

    public boolean onPrepareOptionsMenu(Menu menu){
    	super.onPrepareOptionsMenu(menu);
    	if(mm.getMode() == 0){
    		menu.findItem(R.id.done).setVisible(false);
    		menu.findItem(R.id.clear).setVisible(false);
    	}else{
    		menu.findItem(R.id.done).setVisible(true);
    		menu.findItem(R.id.clear).setVisible(true);
    	}
    	return true;
    }

    public void draw(){
    	switch(mm.getMode()){
    	case 0:
    		drawMain();
    		break;
    	case 1:
    		drawBoard();
    		break;
    	default:
    		break;
    	}
    }

    private void drawMain(){
    	setContentView(R.layout.main);
    	Button startButton = (Button)findViewById(R.id.startButton);
    	startButton.setOnClickListener(new OnClickListener(){
    		public void onClick(View v) {
    			int difficulty = Integer.valueOf(((String)((Spinner)findViewById(R.id.difficultySpinner)).getSelectedItem()));
    			Generator gen = new Generator(difficulty);
    			b.setBoard(gen.getQuestion());
    			//b.setBoard(gen.getQuestion(difficulty));
    			b.setAnswer(gen.getAnswer());
    			mm.setMode(1);
    			draw();
    		}
    	});

    	Button playButton = (Button)findViewById(R.id.restart);
    	playButton.setOnClickListener(new OnClickListener(){
    		public void onClick(View v) {
    			mm.setMode(1);
    			draw();
    		}
    	});
    	((TextView)findViewById(R.id.textView1)).setText("ナンプレジェネレータ");
    	((TextView)findViewById(R.id.help)).setText("・ナンプレの問題を作ってプレイできます。\n" +
    				"・難易度は数字で指定します。\n" +
    				"　数が大きいほど難問になりやすいです。\n\n" +
    				"操作方法\n" +
    				"・タッチしてマスを指定し、\n　下の数字ボタンで挿入する数を決定します。\n" +
    				"・マス長押しで数を消せます。\n" +
    				"・メニューでその他の機能を使用できます。\n" +
    				"・全て埋められたらメニューの\n" +
    				"　「DONE!」で答え合わせできます。\n");

    }

    private void drawBoard(){
    	setContentView(R.layout.board);
    	setBoardCells();
    	setInsertNumbers();
    	setCellText();
    }

    private void setBoardCells(){
    	for(int i=0;i<9;i++){
    		for(int j=0;j<9;j++){
    			boardCells[i][j] = (TextView)findViewById(getResources().getIdentifier("c"+Integer.toString(i)+Integer.toString(j), "id", this.getPackageName()));
    			boardCells[i][j].setOnClickListener(new CellOnClickListener(i,j){
    				public void onClick(View v){
    					if(selectedCellx != -1 && selectedCelly != -1){
    						if(b.getEnableChange(selectedCellx, selectedCelly)){
    							boardCells[selectedCellx][selectedCelly].setBackgroundColor(Color.rgb(255, 255, 255));
    						}
    					}
    					selectedCellx = this.getX();
    					selectedCelly = this.getY();
    					if(b.getEnableChange(selectedCellx, selectedCelly)){
    						boardCells[selectedCellx][selectedCelly].setBackgroundColor(Color.rgb(255, 200, 200));
    					}
    				}
    			});
    			boardCells[i][j].setOnLongClickListener(new CellOnLongClickListener(i, j){
    				@Override
    				public boolean onLongClick(View v) {
    					if(selectedCellx != -1 && selectedCelly != -1){
    						if(b.getEnableChange(selectedCellx, selectedCelly)){
    							boardCells[selectedCellx][selectedCelly].setBackgroundColor(Color.rgb(255,255,255));
    						}
    					}
    					selectedCellx = this.getX();
    					selectedCelly = this.getY();
    					if(b.getEnableChange(selectedCellx, selectedCelly)){
    						b.changeBoard(selectedCellx, selectedCelly, 0);
    						cellReload(selectedCellx, selectedCelly);
    					}
    					return super.onLongClick(v);
    				}
    			});
    			if(!b.getEnableChange(i, j)){
    				boardCells[i][j].setBackgroundColor(Color.rgb(150, 150, 150));
    			}
    		}
    	}
    }

    private void setInsertNumbers(){
    	for(int i=0;i<9;i++){
    		insertNumbers[i] = (TextView)findViewById(getResources().getIdentifier("NUM"+Integer.toString(i+1), "id", this.getPackageName()));
    		insertNumbers[i].setOnClickListener(new InsertNumberOnClickListener(i+1){
    			@Override
    			public void onClick(View v) {
    				super.onClick(v);
    				b.changeBoard(selectedCellx, selectedCelly, this.getNum());
    				cellReload(selectedCellx, selectedCelly);
    			}
    		});
    	}
    }

    private void setCellText(){
    	for(int i=0;i<9;i++){
    		for(int j=0;j<9;j++){
    			boardSetText(i, j);
    			boardCells[i][j].setTextSize(18.0f);
    		}
    	}
    }

    private void cellReload(int x, int y){
    	boardSetText(x, y);
    }

    private void boardSetText(int i, int j){
    	if((i < 0) || (8 < i) || (j < 0) || (8 < j)){
    		return;
    	}

    	int board[][] = b.getBoard();
    	switch(board[i][j]){
		case 1:
			boardCells[i][j].setText(R.string.one);
			break;
		case 2:
			boardCells[i][j].setText(R.string.two);
			break;
		case 3:
			boardCells[i][j].setText(R.string.three);
			break;
		case 4:
			boardCells[i][j].setText(R.string.four);
			break;
		case 5:
			boardCells[i][j].setText(R.string.five);
			break;
		case 6:
			boardCells[i][j].setText(R.string.six);
			break;
		case 7:
			boardCells[i][j].setText(R.string.seven);
			break;
		case 8:
			boardCells[i][j].setText(R.string.eight);
			break;
		case 9:
			boardCells[i][j].setText(R.string.nine);
			break;
		default:
			boardCells[i][j].setText(R.string.space);
			break;
		}
    }
}